/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.Trace;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class BaseException
extends RemoteException {
    private Throwable _nestedException;
    private Object[] _substitutionVars;
    private static final String TRACE_MASKT = "JFBASEXT";
    private static final String TRACE_MASKF = "JFBASEXF";
    private static final String TRACE_MASKD = "JFBASEXD";

    public BaseException(String string) {
        this(string, null, null);
    }

    public BaseException(String string, Object[] objectArray) {
        this(string, objectArray, null);
    }

    public BaseException(String string, Throwable throwable) {
        this(string, null, throwable);
    }

    public BaseException(String string, Object[] objectArray, Throwable throwable) {
        super(string);
        this._substitutionVars = objectArray;
        this._nestedException = throwable;
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, this.toString());
        }
    }

    public Throwable getNestedException() {
        return this._nestedException;
    }

    public String getSubstitutedMessage() {
        return this.getSubstitutedMessage(this.getMessage());
    }

    protected String getSubstitutedMessage(String string) {
        String string2 = this._substitutionVars != null && this._substitutionVars.length > 0 ? MessageFormat.format(string, this._substitutionVars) : string;
        return string2;
    }

    public String getLocalizedMessage() {
        String string;
        try {
            ResourceBundle resourceBundle = this.getResourceBundle();
            string = resourceBundle.getString(this.getMessage());
            string = this.getSubstitutedMessage(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Error in BaseException.getLocalizedMessage()");
                Trace.trace(TRACE_MASKF, "  could not find key [" + this.getMessage() + "] in resource bundle");
            }
            string = this.getSubstitutedMessage(this.getMessage());
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("[").append(",message=").append(this.getMessage());
        if (this._nestedException != null) {
            stringBuffer.append(this._nestedException.toString());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected abstract ResourceBundle getResourceBundle() throws MissingResourceException;
}

